/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;

public class ElementImage
extends CustomElement {
    public String path;
    public boolean allowChange = false;
    public int x;
    public int y;
    public int maxWidth = Integer.MAX_VALUE;
    public int maxHeight = Integer.MAX_VALUE;
    public boolean zoomable;
    public boolean fullSize;
    public boolean templateFile;
    public double zoom = 1.0;
    public int imageOffsetX = 0;
    public int imageOffsetY = 0;

    @Override
    public void drawElement(Graphics2D g) {
        String file = this.path;
        file = this.templateFile ? String.valueOf(CustomCardMaker.templateFolder) + File.separator + this.template.templateName + File.separator + this.path : this.path;
        if (file != null) {
            BufferedImage bi = null;
            if (this.fullSize) {
                bi = this.resizeImage(new ImageIcon(file), CustomCardMaker.cardWidth, CustomCardMaker.cardHeight);
            } else {
                ImageIcon ii = new ImageIcon(file);
                bi = this.resizeImage(new ImageIcon(file), ii.getIconWidth(), ii.getIconHeight());
            }
            g.drawImage((Image)bi, this.x, this.y, null);
        }
    }

    @Override
    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    @Override
    public String generateOutputString(boolean fullExport) {
        String str = "";
        if (this.allowChange) {
            str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";path;" + this.path + "\n";
        }
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";visible;" + this.visible + "\n";
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";zoom;" + this.zoom + "\n";
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";imageOffsetX;" + this.imageOffsetX + "\n";
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";imageOffsetY;" + this.imageOffsetY + "\n";
        return str;
    }
}

